#!/bin/bash
export datasets="physics wikics OGBN-Arxiv"
export datasets2="OGBN-Arxiv"
export missing_rates="0.0 0.1 0.2"
export missing_rates_test="0.1"
export lambda_list="1e-5 1e-4 1e-3 1e-2 1e-1 1e+0 1e+1"
export embedders="GNN"
export embedder_lp_list="GCN_LPA Correct_Smooth"
export attn_type="random sum mean concat"
export gpu=1


for dataset in OGBN-Arxiv
do
for mask in row
do
python main.py --dataset ${dataset} --missing_type ${mask} --missing_rate 0.9999 --embedder LP --n_runs 10 --gpu ${gpu}
python main.py --dataset ${dataset} --missing_type ${mask} --missing_rate 0.9999 --embedder PaGNN --n_runs 10 --gpu ${gpu}
python main.py --dataset ${dataset} --missing_type ${mask} --missing_rate 0.9999 --embedder GNN --filling_method fp --n_runs 10 --gpu ${gpu}
python main.py --dataset ${dataset} --missing_type ${mask} --missing_rate 0.9999 --embedder GNN --filling_method fp --label_trick True --n_reuse 0 --n_runs 10 --gpu ${gpu}
python main.py --dataset ${dataset} --missing_type ${mask} --missing_rate 0.9999 --embedder node2vec_gnn_concat_1 --filling_method fp --n_runs 10 --gpu ${gpu}
python main.py --dataset ${dataset} --missing_type ${mask} --missing_rate 0.9999 --embedder GCN_LPA --filling_method fp --n_runs 10 --gpu ${gpu}
python main.py --dataset ${dataset} --missing_type ${mask} --missing_rate 0.9999 --embedder Correct_Smooth --filling_method fp --n_runs 10 --gpu ${gpu}
done
done

